/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.item.guns.ammo;

import dev.toma.gunsrpg.ModTabs;
import dev.toma.gunsrpg.api.common.IAmmoMaterial;
import dev.toma.gunsrpg.api.common.IAmmoProvider;
import dev.toma.gunsrpg.common.item.BaseItem;
import dev.toma.gunsrpg.common.item.guns.ammo.AmmoType;
import dev.toma.gunsrpg.common.item.guns.ammo.IMaterialData;
import dev.toma.gunsrpg.common.item.guns.ammo.MaterialData;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class AmmoItem
extends BaseItem
implements IAmmoProvider {
    private final AmmoType ammoType;
    private final IAmmoMaterial material;
    private final IMaterialData data;

    public AmmoItem(String name, AmmoType ammoType, IAmmoMaterial material) {
        this(name, ammoType, material, 64);
    }

    public AmmoItem(String name, AmmoType ammoType, IAmmoMaterial material, int ammo) {
        super(name, new Item.Properties().func_200916_a(ModTabs.WEAPON_TAB).func_200917_a(ammo));
        this.material = material;
        this.ammoType = ammoType;
        this.data = ammoType.container != null ? ammoType.container.getMaterialData(material) : MaterialData.EMPTY;
    }

    @Override
    public AmmoType getAmmoType() {
        return this.ammoType;
    }

    @Override
    public IAmmoMaterial getMaterial() {
        return this.material;
    }

    public void func_77624_a(ItemStack stack, @Nullable World level, List<ITextComponent> text, ITooltipFlag flags) {
        ITextComponent recoil = this.formatNumber("recoil", this.data.getAddedRecoil());
        ITextComponent durability = this.formatNumber("durability", this.data.getAddedDurability(), true);
        ITextComponent jam = this.formatNumber("jamming", this.data.getAddedJamChance());
        if (recoil != null || durability != null || jam != null) {
            text.add((ITextComponent)new TranslationTextComponent("ammo.stat.attributes"));
            if (recoil != null) {
                text.add(recoil);
            }
            if (durability != null) {
                text.add(durability);
            }
            if (jam != null) {
                text.add(jam);
            }
        }
    }

    private ITextComponent formatNumber(String key, float value) {
        return this.formatNumber(key, value, false);
    }

    private ITextComponent formatNumber(String key, float value, boolean invertColors) {
        if ((double)value == 0.0) {
            return null;
        }
        int pct = Math.round(value * 100.0f);
        TextFormatting good = invertColors ? TextFormatting.RED : TextFormatting.GREEN;
        TextFormatting bad = invertColors ? TextFormatting.GREEN : TextFormatting.RED;
        TextFormatting formatting = value < 0.0f ? good : bad;
        return new TranslationTextComponent("ammo.stat." + key, new Object[]{pct}).func_240699_a_(formatting);
    }
}

